/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.lib.capability.CapabilityAreaEffect;
import cofh.lib.capability.IAreaEffect;
import cofh.lib.capability.templates.AreaEffectItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AreaEffectHelper;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class AreaEffectEvents {
    private static final Set<Player> HARVESTING_PLAYERS = new ObjectOpenHashSet();
    private static final Set<Player> TILLING_PLAYERS = new ObjectOpenHashSet();

    private AreaEffectEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        block7: {
            block6: {
                Player player2 = event.getPlayer();
                if (!(player2 instanceof ServerPlayer)) break block6;
                player = (ServerPlayer)player2;
                if (!Utils.isClientWorld(player.f_19853_)) break block7;
            }
            return;
        }
        if (HARVESTING_PLAYERS.contains(player)) {
            return;
        }
        HARVESTING_PLAYERS.add((Player)player);
        ItemStack stack = player.m_21205_();
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffect)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(event.getPos(), (Player)player);
        for (BlockPos pos : areaBlocks) {
            if (stack.m_41619_()) break;
            player.f_8941_.m_9280_(pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffect)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(event.getPos(), player);
        float curHardness = event.getState().m_60800_((BlockGetter)player.f_19853_, event.getPos());
        if (curHardness <= 0.0f || areaBlocks.size() <= 1) {
            return;
        }
        float areaMod = Mth.m_14036_((float)(1.0f - 0.01f * (float)areaBlocks.size()), (float)0.1f, (float)1.0f);
        event.setNewSpeed(event.getNewSpeed() * areaMod);
        float maxHardness = AreaEffectEvents.getMaxHardness((BlockGetter)player.f_19853_, areaBlocks, curHardness);
        if (maxHardness > curHardness) {
            event.setNewSpeed(event.getNewSpeed() * curHardness / maxHardness);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HARVESTING_PLAYERS.clear();
            TILLING_PLAYERS.clear();
        }
    }

    private static float getMaxHardness(BlockGetter world, List<BlockPos> areaBlocks, float curHardness) {
        float maxHardness = curHardness;
        for (BlockPos pos : areaBlocks) {
            float testHardness = world.m_8055_(pos).m_60800_(world, pos);
            if (!(testHardness > maxHardness)) continue;
            maxHardness = testHardness;
        }
        return maxHardness;
    }
}

